package com.burhanstore.neonbubblequest.Utils.monetize

import android.app.Activity
import android.util.Log
import android.widget.Toast
import com.burhanstore.neonbubblequest.Utils.AppString
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.DialogManager.claim_dismissDialog
import com.burhanstore.neonbubblequest.Utils.DialogManager.dismissDialog
import com.burhanstore.neonbubblequest.Utils.DialogManager.showDialog
import com.burhanstore.neonbubblequest.Utils.crequest.CoinCredit

object RewardAdManager {
    private const val TG = "RewardAdManager"


    fun fallback1(
        activity: Activity,
        config: String,
        play_from: String?,
        task_id: String?,
        isClick: Boolean = false,
        coin: String
    ) {

        val json_reader = AppString.JsonReader(config)
        val fallback1 = json_reader.get("fallback_1")
        Log.d(TG, "fallback1 ad provider: $fallback1")

        when (fallback1) {


            //admob ads 1st fallback
            "Admob" -> {
                Admob_RewardAd.showAd(
                    activity,
                    onUserEarnedReward = { reward ->
                        // ad closed call
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdComplete = {
                        //
                    },
                    onAdFailed = {
                        fallback2(activity, config, play_from, task_id, isClick, coin)
                        Admob_RewardAd.loadAd(activity)
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("AdEvent Click", "User clicked the rewarded ad")
                    }
                )
            }


            "Facebook" -> {
                Facebook_Ad.showAd(
                    onAdComplete = {
                        // ad closed call
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdFailed = {
                        fallback2(activity, config, play_from, task_id, isClick, coin)
                        Facebook_Ad.loadAd()
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }

            "Vungle" -> {
                Vungle_Ad.showAd(
                    onAdComplete = {
                        // ad closed call
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdFailed = {
                        fallback2(activity, config, play_from, task_id, isClick, coin)
                        Facebook_Ad.loadAd()
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }


            "Applovin" -> {
                Applovin_Ad.showAd(
                    onAdComplete = {
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdFailed = {
                        fallback2(activity, config, play_from, task_id, isClick, coin)
                        Applovin_Ad.loadAd()
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }


            "InMobi" -> {
                InMobi_Ad.showRewardedAd(
                    activity,
                    onAdComplete = {
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdFailed = {
                        fallback2(activity, config, play_from, task_id, isClick, coin)
                        Applovin_Ad.loadAd()
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }


        }
    }


    fun fallback2(
        activity: Activity,
        config: String,
        play_from: String?,
        task_id: String?,
        isClick: Boolean = false,
        coin: String
    ) {

        showDialog()
        val json_reader = AppString.JsonReader(config)
        val fallback_2 = json_reader.get("fallback_2")
        Log.d(TG, "fallback1 ad provider: $fallback_2")

        when (fallback_2) {


            //admob ads 1st fallback
            "Admob" -> {
                Admob_RewardAd.showAd(
                    activity,
                    onUserEarnedReward = { reward ->
                        // ad closed call
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdComplete = {
                        //
                    },
                    onAdFailed = {
                        ad_loadFailed(activity)
                        Admob_RewardAd.loadAd(activity)
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }

            "Facebook" -> {
                Facebook_Ad.showAd(
                    onAdComplete = {
                        // ad closed call
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdFailed = {
                        ad_loadFailed(activity)
                        Facebook_Ad.loadAd()
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }

            "Vungle" -> {
                Vungle_Ad.showAd(
                    onAdComplete = {
                        // ad closed call
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdFailed = {
                        ad_loadFailed(activity)
                        Facebook_Ad.loadAd()
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }


            "Applovin" -> {
                Applovin_Ad.showAd(
                    onAdComplete = {
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdFailed = {
                        ad_loadFailed(activity)
                        Applovin_Ad.loadAd()
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }


            "InMobi" -> {
                InMobi_Ad.showRewardedAd(
                    activity,
                    onAdComplete = {
                        ad_closed(activity, play_from, config, task_id, isClick, coin)
                    },
                    onAdFailed = {
                        ad_loadFailed(activity)
                        Applovin_Ad.loadAd()
                    },
                    onAdClicked = {
                        if (isClick) {
                            adClick_call(activity, config, play_from, task_id)
                        }
                        Log.d("Ad Click", "User clicked the rewarded ad")
                    }
                )
            }


        }
    }

    fun ad_loadFailed(activity: Activity) {
        DialogManager.dismissDialog()
        Toast.makeText(
            activity,
            "Ad is currently unavailable. Try again shortly.",
            Toast.LENGTH_SHORT
        ).show()
    }

    fun ad_closed(
        activity: Activity,
        request_place: String? = null,
        config: String? = null,
        task_id: String? = null,
        isClick: Boolean = false,
        coin: String
    ) {

        //dialog close
        claim_dismissDialog()
        dismissDialog()


        //coin add
        if (request_place.equals("Game")) {
            CoinCredit.gameWinRewardAdd(activity, coin)
        } else if (request_place.equals("daily_reward")) {
            //  CoinCredit.daily_cAdd(activity, request_place, config, task_id, isClick, coin)
        }


    }

    fun adClick_call(
        activity: Activity,
        coin: String?,
        playFrom: String?,
        taskId: String?
    ) {

    }

}